<?php

use App\Http\Controllers\Admin\AGR\AGRAdminController;
use App\Http\Controllers\Admin\AIR\AIRAdminController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\CustomerImportController;
use App\Http\Controllers\ProfileCustomerController;
use App\Http\Controllers\Search\SearchCustommer;
use App\Http\Controllers\User\AGR\AGRUserController;
use App\Http\Controllers\User\AIR\AIRUserController;
use App\Http\Middleware\AdminMiddleware;
use Illuminate\Support\Facades\Route;
use Inertia\Inertia;

Route::get('/', function () {
    return Inertia::render('Welcome');
})->name('home');
Route::get('dashboard',function(){
    return view('dash');
})->middleware(['auth', 'verified'])->name('dashboard');
// Route::get('dashboard', function () {
//     return Inertia::render('Dashboard');
// })->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function(){
    Route::get('profile/{sn_san_pham}', [ProfileCustomerController::class, 'showProfile'])->name('profile.index');
    Route::get('search-by-id', [SearchCustommer::class, 'searchByIDKhach'])->name('search.byid');

    Route::get('search-by-sn', [SearchCustommer::class, 'searchBySN'])->name('search.bysn');
});

Route::get('/import', [CustomerImportController::class, 'showForm']);
Route::post('/import', [CustomerImportController::class, 'import'])->name('import.customers');

Route::middleware(['auth', 'check.role:admin'])->group(function () {
    Route::prefix('agr')->group(function () {
        Route::get('admin/dashboard', [AGRAdminController::class, 'index']);
    });

    Route::prefix('air')->group(function () {
        Route::get('admin/dashboard', [AIRAdminController::class, 'index']);
    });

});


Route::middleware(['auth', 'check.role:user'])->group(function () {
    Route::prefix('agr')->group(function () {
        Route::get('user/dashboard', [AGRUserController::class, 'index']);
    });

    Route::prefix('air')->group(function () {
        Route::get('user/dashboard', [AIRUserController::class, 'index']);
    });
});




require __DIR__.'/settings.php';
require __DIR__.'/auth.php';
