document.addEventListener("DOMContentLoaded", function() {
    var e = document.querySelector(".invoice-list-table");
    if (e) {
        let a = new DataTable(e,{
            ajax: assetsPath + "json/invoice-list.json",
            columns: [{
                data: "invoice_id"
            }, {
                data: "invoice_id",
                orderable: !1,
                render: DataTable.render.select()
            }, {
                data: "invoice_id"
            }, {
                data: "invoice_status"
            }, {
                data: "issued_date"
            }, {
                data: "client_name"
            }, {
                data: "total"
            }, {
                data: "balance"
            }, {
                data: "invoice_status"
            }, {
                data: "action"
            }],
            columnDefs: [{
                className: "control",
                responsivePriority: 2,
                searchable: !1,
                targets: 0,
                render: function() {
                    return ""
                }
            }, {
                targets: 1,
                orderable: !1,
                searchable: !1,
                responsivePriority: 4,
                render: function() {
                    return '<input type="checkbox" class="dt-checkboxes form-check-input">'
                }
            }, {
                targets: 2,
                render: function(e, t, a) {
                    return `<a href="app-invoice-preview.html">#${a.invoice_id}</a>`
                }
            }, {
                targets: 3,
                render: function(e, t, a) {
                    var n = a.invoice_status;
                    return `
              <span class="d-inline-block" data-bs-toggle="tooltip" data-bs-html="true" title="<span>${`
              ${n}<br>
              <span class="fw-medium">Balance:</span> ${a.balance}<br>
              <span class="fw-medium">Due Date:</span> ${a.due_date}
            `.replace(/"/g, "&quot;")}">
                ${{
                        Sent: '<span class="badge p-1_5 rounded-pill bg-label-secondary"><i class="icon-base icon-16px bx bx-envelope"></i></span>',
                        Draft: '<span class="badge p-1_5 rounded-pill bg-label-primary"><i class="icon-base icon-16px bx bx-folder"></i></span>',
                        "Past Due": '<span class="badge p-1_5 rounded-pill bg-label-danger"><i class="icon-base icon-16px bx bx-error"></i></span>',
                        "Partial Payment": '<span class="badge p-1_5 rounded-pill bg-label-success"><i class="icon-base icon-16px bx bx-check"></i></span>',
                        Paid: '<span class="badge p-1_5 rounded-pill bg-label-warning"><i class="icon-base icon-16px bx bx-pie-chart-alt"></i></span>',
                        Downloaded: '<span class="badge p-1_5 rounded-pill bg-label-info"><i class="icon-base icon-16px bx bx-down-arrow-alt"></i></span>'
                    }[n] || ""}
              </span>
              </span>
            `
                }
            }, {
                targets: 4,
                responsivePriority: 2,
                render: function(e, t, a) {
                    var n = a.client_name
                      , s = a.service
                      , a = a.avatar_image
                      , o = Math.floor(11 * Math.random()) + 1;
                    let l;
                    return `
              <div class="d-flex justify-content-start align-items-center">
                <div class="avatar-wrapper">
                  <div class="avatar avatar-sm me-3">
                    ${l = !0 === a ? `<img src="${assetsPath}img/avatars/${o + ".png"}" alt="Avatar" class="rounded-circle">` : `<span class="avatar-initial rounded-circle bg-label-${["success", "danger", "warning", "info", "dark", "primary", "secondary"][Math.floor(6 * Math.random())]}">${(n.match(/\b\w/g) || []).slice(0, 2).map(e => e.toUpperCase()).join("")}</span>`}
                  </div>
                </div>
                <div class="d-flex flex-column">
                  <a href="pages-profile-user.html" class="text-heading text-truncate"><span class="fw-medium">${n}</span></a>
                  <small class="text-truncate">${s}</small>
                </div>
              </div>
            `
                }
            }, {
                targets: 5,
                render: function(e, t, a) {
                    a = a.total;
                    return `<span class="d-none">${a}</span>$` + a
                }
            }, {
                targets: 6,
                render: function(e, t, a) {
                    a = new Date(a.due_date);
                    return `
              <span class="d-none">${a.toISOString().slice(0, 10).replace(/-/g, "")}</span>
              ${a.toLocaleDateString("en-GB", {
                        day: "2-digit",
                        month: "short",
                        year: "numeric"
                    })}
            `
                }
            }, {
                targets: 7,
                orderable: !1,
                render: function(e, t, a) {
                    a = a.balance;
                    return 0 === a ? '<span class="badge bg-label-success text-capitalized"> Paid </span>' : `<span class="d-none">${a}</span><span class="text-heading">${a}</span>`
                }
            }, {
                targets: 8,
                visible: !1
            }, {
                targets: -1,
                title: "Actions",
                searchable: !1,
                orderable: !1,
                render: function() {
                    return '<div class="d-flex align-items-center"><a href="javascript:;" data-bs-toggle="tooltip" class="btn btn-icon delete-record" data-bs-placement="top" title="Delete"><i class="icon-base bx bx-trash icon-md"></i></a><a href="app-invoice-preview.html" data-bs-toggle="tooltip" class="btn btn-icon" data-bs-placement="top" title="Preview Invoice"><i class="icon-base bx bx-show icon-md"></i></a><div class="dropdown"><a href="javascript:;" class="btn dropdown-toggle hide-arrow btn-icon p-0" data-bs-toggle="dropdown"><i class="icon-base bx bx-dots-vertical-rounded icon-md"></i></a><div class="dropdown-menu dropdown-menu-end"><a href="javascript:;" class="dropdown-item">Download</a><a href="app-invoice-edit.html" class="dropdown-item">Edit</a><a href="javascript:;" class="dropdown-item">Duplicate</a></div></div>'
                }
            }],
            select: {
                style: "multi",
                selector: "td:nth-child(2)"
            },
            order: [[2, "desc"]],
            displayLength: 10,
            layout: {
                topStart: {
                    rowClass: "row m-3 justify-content-between",
                    features: [{
                        pageLength: {
                            menu: [10, 25, 50, 100],
                            text: "Show_MENU_"
                        },
                        buttons: [{
                            text: '<i class="icon-base icon-16px bx bx-plus me-md-2"></i><span class="d-md-inline-block d-none">Create Invoice</span>',
                            className: "btn btn-primary",
                            action: function() {
                                window.location = "app-invoice-add.html"
                            }
                        }]
                    }]
                },
                topEnd: {
                    rowClass: "row mx-3 justify-content-between",
                    features: [{
                        search: {
                            placeholder: "Search Invoice",
                            text: "_INPUT_"
                        }
                    }]
                },
                bottomStart: {
                    rowClass: "row mx-3 justify-content-between",
                    features: ["info"]
                },
                bottomEnd: {
                    paging: {
                        firstLast: !1
                    }
                }
            },
            language: {
                paginate: {
                    next: '<i class="icon-base bx bx-chevron-right scaleX-n1-rtl icon-18px"></i>',
                    previous: '<i class="icon-base bx bx-chevron-left scaleX-n1-rtl icon-18px"></i>'
                }
            },
            responsive: {
                details: {
                    display: DataTable.Responsive.display.modal({
                        header: function(e) {
                            return "Details of " + e.data().client_name
                        }
                    }),
                    type: "column",
                    renderer: function(e, t, a) {
                        var n, s, o, a = a.map(function(e) {
                            return "" !== e.title ? `<tr data-dt-row="${e.rowIndex}" data-dt-column="${e.columnIndex}">
                      <td>${e.title}:</td>
                      <td>${e.data}</td>
                    </tr>` : ""
                        }).join("");
                        return !!a && ((n = document.createElement("div")).classList.add("table-responsive"),
                        s = document.createElement("table"),
                        n.appendChild(s),
                        s.classList.add("table"),
                        (o = document.createElement("tbody")).innerHTML = a,
                        s.appendChild(o),
                        n)
                    }
                }
            },
            initComplete: function() {
                let e = document.querySelector(".invoice_status");
                var t;
                !e && ((e = document.createElement("div")).className = "invoice_status",
                t = document.querySelector(".dt-layout-end")) && t.appendChild(e),
                this.api().columns(8).every(function() {
                    let t = this
                      , a = document.createElement("select");
                    a.id = "UserRole",
                    a.className = "form-select",
                    a.innerHTML = '<option value=""> Invoice Status </option>',
                    e.appendChild(a),
                    a.addEventListener("change", function() {
                        var e = a.value ? `^${a.value}$` : "";
                        t.search(e, !0, !1).draw()
                    }),
                    t.data().unique().sort().each(function(e) {
                        var t = document.createElement("option");
                        t.value = e,
                        t.className = "text-capitalize",
                        t.textContent = e,
                        a.appendChild(t)
                    })
                })
            }
        });
        function n(e) {
            let t = document.querySelector(".dtr-expanded");
            (t = e ? e.target.parentElement.closest("tr") : t) && a.row(t).remove().draw()
        }
        function t() {
            var e = document.querySelector(".invoice-list-table");
            let t = document.querySelector(".dtr-bs-modal");
            e && e.classList.contains("collapsed") ? t && t.addEventListener("click", function(e) {
                e.target.parentElement.classList.contains("delete-record") && (n(),
                e = t.querySelector(".btn-close")) && e.click()
            }) : (e = e?.querySelector("tbody")) && e.addEventListener("click", function(e) {
                e.target.parentElement.classList.contains("delete-record") && n(e)
            })
        }
        t(),
        document.addEventListener("show.bs.modal", function(e) {
            e.target.classList.contains("dtr-bs-modal") && t()
        }),
        document.addEventListener("hide.bs.modal", function(e) {
            e.target.classList.contains("dtr-bs-modal") && t()
        }),
        a.on("draw", function() {
            document.querySelectorAll('[data-bs-toggle="tooltip"]').forEach(e => {
                new bootstrap.Tooltip(e,{
                    boundary: document.body
                })
            }
            )
        })
    }
    setTimeout( () => {
        [{
            selector: ".dt-buttons .btn",
            classToRemove: "btn-secondary"
        }, {
            selector: ".dt-buttons",
            classToAdd: "mb-0"
        }, {
            selector: ".dt-search .form-control",
            classToRemove: "form-control-sm"
        }, {
            selector: ".dt-length .form-select",
            classToRemove: "form-select-sm"
        }, {
            selector: ".dt-length",
            classToAdd: "me-2 mb-6"
        }, {
            selector: ".dt-search",
            classToAdd: "me-sm-0 me-4"
        }, {
            selector: ".dt-layout-end",
            classToRemove: "justify-content-between",
            classToAdd: "justify-content-md-between justify-content-center d-flex flex-wrap gap-sm-4 mb-sm-0 mb-6 mt-0 pe-md-3 ps-0"
        }, {
            selector: ".dt-layout-start",
            classToAdd: "px-3 pe-md-0 mt-0"
        }, {
            selector: ".dt-layout-table",
            classToRemove: "row mt-2"
        }, {
            selector: ".dt-layout-full",
            classToRemove: "col-md col-12",
            classToAdd: "table-responsive"
        }].forEach( ({selector: e, classToRemove: a, classToAdd: n}) => {
            document.querySelectorAll(e).forEach(t => {
                a && a.split(" ").forEach(e => t.classList.remove(e)),
                n && n.split(" ").forEach(e => t.classList.add(e))
            }
            )
        }
        )
    }
    , 100)
});
