<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;
use App\Model\User;

class AdminMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next, string $role): Response
    {
        $user = auth()->user();

        if (!$user || $user->role !== $role) {
            abort(403, 'Bạn không có quyền truy cập.');
        }

        // Lấy branch (ví dụ từ cột `branch` trong bảng users)
        $branch = $user->branch;

        // Kiểm tra xem URL hiện tại có chứa đúng prefix theo branch
        $prefix = strtoupper($branch) . '/' . $role;
        if (!str_starts_with($request->path(), strtolower($prefix))) {
            // Nếu không đúng prefix thì chuyển hướng
            return redirect(strtolower("/{$branch}/{$role}/dashboard"));
        }

        return $next($request);
    }
}
