<?php

namespace App\Http\Controllers\Api\Search;

use App\Http\Controllers\Controller;
use App\Models\Customer;
use Illuminate\Http\Request;

class SearchDataController extends Controller
{
    public function searchData(Request $request)
    {
        $query = $request->input('query');

        $customers = Customer::where(function ($q) use ($query) {
            $q->where('sn_san_pham', 'like', '%' . $query . '%')
                ->orWhere('sn_tay_cam', 'like', '%' . $query . '%');
        })
            ->limit(10)
            ->get()
            ->map(function ($cus) {
                return [
                    'id_6_so' => $cus->id_6_so,
                    'id_kh_mn' => $cus->id_kh_mn,
                    'ten_khach_hang' => $cus->ten_khach_hang,
                    'sn_san_pham' => $cus->sn_san_pham,
                    'sn_tay_cam' => $cus->sn_tay_cam,
                    'ngay_active' => $cus->ngay_active,
                    'goi_bh' => $cus->goi_bh,

                ];
            });

        return response()->json($customers);
    }

    public function searchCus(Request $request)
    {
        $query = $request->input('query');

        $customers = Customer::where(function ($q) use ($query) {
            $q->where('id_6_so', 'like', '%' . $query . '%')
                ->orWhere('id_kh_mn', 'like', '%' . $query . '%')
                ->orWhere('ten_khach_hang', 'like', '%' . $query . '%');
        })
            ->limit(10)
            ->get()
            ->map(function ($cus) {
                return [
                    'id_6_so' => $cus->id_6_so,
                    'id_kh_mn' => $cus->id_kh_mn,
                    'ten_khach_hang' => $cus->ten_khach_hang,
                    'sn_san_pham' => $cus->sn_san_pham,
                    'sn_tay_cam' => $cus->sn_tay_cam,
                    'ngay_active' => $cus->ngay_active,
                    'goi_bh' => $cus->goi_bh,
                    'url' => route('profile.index', $cus->sn_san_pham),
                ];
            });

        return response()->json($customers);
    }
}
