<?php

namespace App\Imports;

use App\Models\Customer;
use Illuminate\Contracts\Queue\ShouldQueue;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithMapping;

class CustomersImport implements ToModel, WithChunkReading, WithHeadingRow, ShouldQueue, WithMapping
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function map($row): array
    {
        return [
            $row['id_6_so'],
            $row['ncu'],
            $row['ten_khach_hang_moi_nhat_tinh_trang_hang_idrone'],
            $row['loai_san_pham'],
            $row['sn_san_pham_hang_cung_capproductsnfinalxnk_nhap'],
            $row['ten_san_pham_xnk_nhap'],
            $row['ngay_xuat_lan_1_thong_tin_phuc_vu_tra_cuu_bao_hanh_san_pham_ktk_nhap'],
            $row['ngay_active_anh_tam_nhap'],
            $row['goi_bao_hanh_ktk_nhap_sua_lai_co_gan_voi_truong_hop_nam_trong_black_list_cua_sale_ket_noi_voi_tinh_trang_chinh_sach_moi_nhat_cua_file_idrone_so_lan_sac_tinh_trang_ngoai_quan'],
            $row['phan_loai_trong_ngoai_he_thong'],
            $row['black_list_sale'],
            $row['black_list_ktbh'],
        ];
    }

    public function model(array $row)
{
    return new Customer([
        'id_6_so' => $row[0],  // cột 1
        'ncu' => $row[1],      // cột 2
        'ten_khach_hang' => $row[2], // cột 3
        'loai_san_pham' => $row[3],  // cột 4
        'sn_san_pham' => $row[4],    // cột 5
        'ten_san_pham' => $row[5],   // cột 6
        'ngay_xuat_lan_1' => $row[6],// cột 7
        'ngay_active' => $row[7],    // cột 8
        'goi_bao_hanh' => $row[8],   // cột 9
        'phan_loai' => $row[9],      // cột 10
        'black_list_sale' => $row[10], // cột 11
        'black_list_ktbh' => $row[11], // cột 12
    ]);
}


    public function chunkSize(): int
    {
        return 500;
    }
}
