<?php

namespace App\Http\Controllers;

use App\Imports\CustomersImport;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class CustomerImportController extends Controller
{
    public function showForm()
    {
        return view('import-form');
    }

    public function import(Request $request)
    {
        try {
        $request->validate([
            'file' => 'required|file|mimes:xlsx,xls,csv'
        ]);

        Excel::import(new CustomersImport, $request->file('file'));

        return response()->json([
            'success' => true,
            'message' => 'Import thành công!'
        ]);

    } catch (\Exception $e) {
        // Bắt lỗi để tránh response lỗi trắng hoặc mã lỗi HTTP không chuẩn
        return response()->json([
            'success' => false,
            'message' => 'Lỗi khi import: ' . $e->getMessage()
        ], 500);
    }
    }

}
