<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Customer;
use Illuminate\Http\Request;
use Log;
use Validator;

class CustomerImportController extends Controller
{
   public function import(Request $request)
    {
        // Bước 1: Validate dữ liệu
        $validated = $request->validate([
            'id_6_so' => 'required|string|max:255',
            'ncu' => 'nullable|string',
            'id_kh_mn' => 'nullable|string',
            'ten_khach_hang' => 'nullable|string',
            'loai_san_pham' => 'nullable|string',
            'sn_san_pham' => 'required|string|max:255',
            'ten_san_pham' => 'nullable|string',
            'ngay_xuat_1' => 'nullable|date',
            'ngay_xuat_mn' => 'nullable|date',
            'ngay_active' => 'nullable|date',
            'sn_tay_cam' => 'nullable|string',
            'goi_bh' => 'nullable|string',
            'ma_dh' => 'nullable|string',
            'ngay_nhan_coc' => 'nullable|date',
            'phan_loai' => 'nullable|string',
            'black_list_sale' => 'nullable|string',
            'black_list_ktbh' => 'nullable|string',
        ]);

        // Bước 2: Lưu dữ liệu vào bảng "customers"
        Customer::updateOrCreate(
            ['sn_san_pham' => $validated['sn_san_pham']], // Điều kiện tìm
            $validated // Dữ liệu cập nhật hoặc tạo mới
        );
    Log::info('Saved customer', $validated);

        // Bước 3: Trả về kết quả
        return response()->json(['message' => 'Data imported successfully!']);
    }
}
